<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */
 
  /*===================================================
    ShowFormLogin()
  ===================================================*/

  function ShowFormLogin() {

    // vars global configuration
    global $theme_path;

    // vars url & form
    global $f, $b;

    // vars template
    global $error_msg;

    if ($f == 1)
      DisplayTemplate($theme_path . "permission_error.html", "\$error_msg,\$username,\$password,\$f,\$b");
    else
      DisplayTemplate($theme_path . "login_form.html", "\$error_msg,\$username,\$password,\$f,\$b");
  }
  
  
  /*===================================================
    ProcessFormLogin()
  ===================================================*/

  function ProcessFormLogin() {

    // vars global configuration
    global $dbConn, $theme_path, $user_auth_type;

    // vars url & form
    global $username, $password, $remember_me, $f, $b, $u, $p;

    // vars messages
    global $msg;

    // vars template
    global $error_msg;

    // verify input

    if (empty($u) && empty($p)) {
      if (empty($username))
        $error_msg = $msg["10091"];
      elseif (strlen($username) < 3)
        $error_msg = $msg["10092"];
      elseif (empty($password))
        $error_msg = $msg["10093"];
    }
    else {
      $username = $u;
      $password = $p;
    }

    if (empty($error_msg)) {
      $users_obj = new clsUsers;
      $users_obj->table_name = "idx_users";

      if ($remember_me) {
        $expire = time() + (3600 * 24 * 1000); // 1000 days
      } 
      else {
        $expire = 0; // expire when browser closed
      }
      
      $auth = new auth();
      $login = $users_obj->Login($username, $auth->Convert($password), $expire);

      if ($login == '1') {
        $error_msg = $msg["10094"];
        ShowFormLogin();
      }
      else {
        if ($f == 1 && !empty($b) && $b != 'http://') {
          Redirect($b);
        }
        else {
          Redirect('index.php');
        }
      }
    }
    else {
      ShowFormLogin();
    }
  }


  /*===================================================
    main
  ===================================================*/

  include "application.php";

  RunPreFilter(__FILE__);

  if (empty($pflag)) {
    ShowFormLogin();
  }
  elseif ($pflag == 'login') {
    ProcessFormLogin();
  }

  RunPostFilter(__FILE__);

?>